<?php $__env->startSection('content'); ?>
  <div class="content-wrapper">
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="textWhite">Edit Role</h1>
          </div>
        </div>
      </div>
    </section>
    
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-md-12">
            <div class="card">
              <form action="<?php echo e(route('admin.roles.update')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <div class="card-body">
                  <div class="form-group">
                    <label>Name</label>
                    <input type="text" class="form-control" name="name" value="<?php echo e(old('name', $role->name)); ?>" placeholder="Name">
                    <input type="hidden" class="form-control" name="role_id" value="<?php echo e($role->id); ?>">
                    <span class="text-danger"><?php echo e($errors->has('name') ? $errors->first('name') : ""); ?></span>
                  </div>
                  <div class="form-group mb-0">
                    <label>Permissions</label>
                  </div>
                  <div class="form-group">
                    <div class="form-check">
                      <input type="checkbox" class="form-check-input" id="permissionAll" value="1" <?php echo e(App\Models\User::roleHasAllPermissions($role, $allPermissions) ? 'checked' : ''); ?>>
                      <label for="permissionAll">All</label>
                    </div>
                    <hr>
                  </div>

                  <?php $groupIndex = 1; ?>
                  <?php $__currentLoopData = $permissionGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row mb-2">
                      <?php
                        $permissions = App\Models\User::getPermissionsByGroupName($group->name);
                      ?>
                      <div class="col-md-3">
                        <div class="form-group">
                          <div class="form-check">
                            <input 
                              type="checkbox" 
                              class="form-check-input" 
                              id="role-permissions-group<?php echo e($groupIndex); ?>" 
                              value="<?php echo e($group->name); ?>" 
                              onclick="checkPermissionByGroup('role-permissions<?php echo e($groupIndex); ?>', this)"
                              <?php echo e(App\Models\User::roleHasAllPermissions($role, $permissions) ? 'checked' : ''); ?>

                            >
                            <label for="role-permissions-group<?php echo e($groupIndex); ?>"><?php echo e($group->name); ?></label>
                          </div>
                        </div>
                      </div>

                      <div class="col-md-9 role-permissions<?php echo e($groupIndex); ?>">
                        <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <div class="form-group m-0">
                            <div class="form-check">
                              <input 
                                type="checkbox" 
                                class="form-check-input" 
                                id="permission<?php echo e($permission->id); ?>" 
                                name="permissions[]" 
                                value="<?php echo e($permission->name); ?>"
                                <?php if(old('permissions') !== null && in_array($permission->name, old('permissions'))): ?> checked <?php endif; ?>
                                <?php echo e($role->hasPermissionTo($permission->name) ? 'checked' : ''); ?>

                                onclick="checkSinglePermission('role-permissions<?php echo e($groupIndex); ?>', 'role-permissions-group<?php echo e($groupIndex); ?>', <?php echo e(count($permissions)); ?>)"
                              >
                              <label class="form-check-label" for="permission<?php echo e($permission->id); ?>"><?php echo e($permission->name); ?></label>
                            </div>
                          </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </div>
                    </div>
                    <?php  $groupIndex++; ?>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
                <div class="card-footer">
                  <button type="submit" class="btn btn-primary customButton">Submit</button>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </section>
  </div>

  <script>
    document.addEventListener("DOMContentLoaded", function () {
      document.getElementById("permissionAll").addEventListener("click", function () {
        var checkboxes = document.querySelectorAll('input[type="checkbox"]');
        checkboxes.forEach(function (checkbox) {
          checkbox.checked = document.getElementById("permissionAll").checked;
        });
      });
    });

    function checkPermissionByGroup(permissionClassName, checkThis) {
      const groupCheckbox = document.getElementById(checkThis.id);
      const permissionCheckboxes = document.querySelectorAll('.' + permissionClassName + ' input');
  
      if (groupCheckbox.checked) {
        permissionCheckboxes.forEach(function(checkbox) {
          checkbox.checked = true;
        });
      } else {
        permissionCheckboxes.forEach(function(checkbox) {
          checkbox.checked = false;
        });
      }
      
      updateAllPermissionsCheckbox();
    }

    function checkSinglePermission(permissionClassName, groupID, countTotalPermission) {
      const permissionCheckboxes = document.querySelectorAll('.' + permissionClassName + ' input');
      const groupIDCheckbox = document.getElementById(groupID);

      let checkedCount = 0;
      permissionCheckboxes.forEach(function(checkbox) {
          if (checkbox.checked) {
              checkedCount++;
          }
      });

      if (checkedCount === countTotalPermission) {
          groupIDCheckbox.checked = true;
      } else {
          groupIDCheckbox.checked = false;
      }

      updateAllPermissionsCheckbox();
    }

    function updateAllPermissionsCheckbox() {
      const totalPermissionsCount = <?php echo e(count($allPermissions)); ?>;
      const totalPermissionGroupsCount = <?php echo e(count($permissionGroups)); ?>;
      
      const allCheckboxes = document.querySelectorAll('input[type="checkbox"]');
      const checkedCheckboxesCount = Array.from(allCheckboxes).filter(checkbox => checkbox.checked).length;

      const permissionAllCheckbox = document.getElementById("permissionAll");
      if (checkedCheckboxesCount >= (totalPermissionsCount + totalPermissionGroupsCount)) {
        permissionAllCheckbox.checked = true;
      } else {
        permissionAllCheckbox.checked = false;
      }
    }

  </script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\VPNCodeCanyon\resources\views/backend/admin/role_and_permission/edit.blade.php ENDPATH**/ ?>