<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Modify existing status field to include more states
            $table->dropColumn('status');
            $table->enum('status', ['active', 'blocked', 'banned', 'suspended'])->default('active');
            
            // Add trial-related fields
            $table->boolean('is_trial')->default(false);
            $table->timestamp('trial_expires_at')->nullable();
            
            // Add IMEI field
            $table->string('imei')->nullable()->unique();
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['is_trial', 'trial_expires_at', 'imei']);
            $table->dropColumn('status');
            $table->unsignedTinyInteger('status')->default(0)->nullable()->comment('0: active, 1: blocked');
        });
    }
};