<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VpnPayload extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'config',
        'status',
        'priority',
        'last_checked_at',
        'success_rate',
        'type',
        'metadata'
    ];

    protected $casts = [
        'config' => 'json',
        'metadata' => 'json',
        'last_checked_at' => 'datetime',
        'success_rate' => 'integer'
    ];

    public function isAvailable()
    {
        return $this->status === 'live' && $this->success_rate > 50;
    }

    public function scopeAvailable($query)
    {
        return $query->where('status', 'live')
                     ->where('success_rate', '>', 50)
                     ->orderBy('priority', 'desc');
    }
}