<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConnectionLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'ip_address',
        'connected_at',
        'disconnected_at',
        'server_name',
        'protocol',
        'bytes_sent',
        'bytes_received'
    ];

    protected $casts = [
        'connected_at' => 'datetime',
        'disconnected_at' => 'datetime'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}